/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.iot.discovery;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jivesoftware.smack.util.Async;
import org.jivesoftware.smackx.iot.discovery.ThingStateChangeListener;
import org.jivesoftware.smackx.iot.element.NodeInfo;
import org.jxmpp.jid.BareJid;

public class ThingState {
    private final NodeInfo nodeInfo;
    private BareJid registry;
    private BareJid owner;
    private boolean removed;
    private final List<ThingStateChangeListener> listeners = new CopyOnWriteArrayList<ThingStateChangeListener>();

    ThingState(NodeInfo nodeInfo) {
        this.nodeInfo = nodeInfo;
    }

    void setRegistry(BareJid registry) {
        this.registry = registry;
    }

    void setUnregistered() {
        this.registry = null;
    }

    void setOwner(final BareJid owner) {
        this.owner = owner;
        Async.go((Runnable)new Runnable(){

            @Override
            public void run() {
                for (ThingStateChangeListener thingStateChangeListener : ThingState.this.listeners) {
                    thingStateChangeListener.owned(owner);
                }
            }
        });
    }

    void setUnowned() {
        this.owner = null;
    }

    void setRemoved() {
        this.removed = true;
    }

    public NodeInfo getNodeInfo() {
        return this.nodeInfo;
    }

    public BareJid getRegistry() {
        return this.registry;
    }

    public BareJid getOwner() {
        return this.owner;
    }

    public boolean isOwned() {
        return this.owner != null;
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public boolean setThingStateChangeListener(ThingStateChangeListener thingStateChangeListener) {
        return this.listeners.add(thingStateChangeListener);
    }

    public boolean removeThingStateChangeListener(ThingStateChangeListener thingStateChangeListener) {
        return this.listeners.remove(thingStateChangeListener);
    }
}

